/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.
//
// And then further adapted to optimise it somewhat.  The improvement, while not
// huge, made a noticable difference with one of my more complex scenes. TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

const vec2 d00 = vec2(0.0,0.0);
const vec2 d01 = vec2(0.0,1.0);
const vec2 d10 = vec2(1.0,0.0);
const vec2 d11 = vec2(1.0,1.0);

#define rand(n) fract ( sin(dot(n,vec2(12.9898,4.1414))) * 43758.5453 )

#define noise(n,f) mix ( mix ( rand(n),     rand(n+d10), f.x ),       \
                         mix ( rand(n+d01), rand(n+d11), f.x ), f.y )

float fbm(vec2 n1)
 {
   vec2 n2 = n1 * 2.0;
   vec2 n3 = n2 * 2.0;
   vec2 n4 = n3 * 2.0;
   vec2 n5 = n4 * 2.0;
   vec2 n6 = n5 * 2.0;
   vec2 n7 = n6 * 2.0;

   vec2 f1 = smoothstep(d00,d11,fract(n1));
   vec2 f2 = smoothstep(d00,d11,fract(n2));
   vec2 f3 = smoothstep(d00,d11,fract(n3));
   vec2 f4 = smoothstep(d00,d11,fract(n4));
   vec2 f5 = smoothstep(d00,d11,fract(n5));
   vec2 f6 = smoothstep(d00,d11,fract(n6));
   vec2 f7 = smoothstep(d00,d11,fract(n7));

   return noise(floor(n1),f1)
        + noise(floor(n2),f2) * 0.5
        + noise(floor(n3),f3) * 0.25
        + noise(floor(n4),f4) * 0.125
        + noise(floor(n5),f5) * 0.0625
        + noise(floor(n6),f6) * 0.03125
        + noise(floor(n7),f7) * 0.015625;

 }

const vec3 c1 = vec3 ( 0.1, 0.0, 0.0 );
const vec3 c2 = vec3 ( 0.7, 0.0, 0.0 );
const vec3 c3 = vec3 ( 0.2, 0.0, 0.0 );
const vec3 c4 = vec3 ( 1.0, 0.9, 0.0 );
const vec3 c5 = vec3 ( 0.1, 0.1, 0.1 );
const vec3 c6 = vec3 ( 0.9, 0.9, 0.9 );

float t1 = iGlobalTime * 0.1;
float t2 = iGlobalTime * 0.7;
float t3 = iGlobalTime * 0.4;

void main()
 {
   float f = cos(1.57*gl_FragCoord.y/iResolution.y);

   vec2 p = gl_FragCoord.xy*8.0/iResolution.xx;
   vec2 q = p + fbm(p-t1);
   vec2 r = vec2 ( fbm(q+t3-p.x-p.y), fbm(q-t3) );

   vec3 c = mix(c1,c2,fbm(p+r)) + mix(c3,c4,r.x) - mix(c5,c6,r.y);

   gl_FragColor = vec4 ( c*f, 1.0 );

}
